{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 16.09.98 - 13:51:04 $                                        =}
{========================================================================}
unit Unit1;

{$I COMPILER.INC}

{.$DEFINE MPEGTRIAL}

//NOTE: // We would make sure you read this
// if you get a error message with mpeg wave files please disable:
// Tools/Options/Defaults/break on exceptions !!!

interface

uses
  Windows,
  Messages,
  ShellAPI,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Buttons,
  ComCtrls,
  StdCtrls,
  ExtCtrls,
  Menus,
  MMSystem,
  MMUtils,
  MMAbout,
  MMObj,
  MMDSPObj,
  MMWaveIO,
  MMMPType,
  MMMPEG,
  MMDesign,
  MMWavOut,
  MMDIBCv,
  MMLevel,
  MMConect,
  MMSpectr,
  MMHTimer,
  MMSlider,
  MMLEDS,
  MMPanel,
  MMSpin,
  MMLEDLbl,
  MMButton,
  MMWave,
  MMLabel,
  MMHook;

type
  TMainForm = class(TForm)
    OpenDialog: TOpenDialog;
    WaveOut: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    MMConnector1: TMMConnector;
    HiTimer: TMMHiTimer;
    MMPanel2: TMMPanel;
    ButtonPanel: TMMPanel;
    DisplayPanel: TMMPanel;
    MMPanel7: TMMPanel;
    MMLevelScale1: TMMLevelScale;
    digit: TMMLEDDigit;
    MMLevel2: TMMLevel;
    MMLevel1: TMMLevel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    MMSpectrum1: TMMSpectrum;
    ss1: TMMLEDDigit;
    ss2: TMMLEDDigit;
    mm1: TMMLEDDigit;
    mm2: TMMLEDDigit;
    btnStop: TMMSpeedButton;
    btnPlay: TMMSpeedButton;
    btnPause: TMMSpeedButton;
    btnOpen: TMMSpeedButton;
    btnSkipL: TMMSpeedButton;
    btnSkipR: TMMSpeedButton;
    btnClose: TMMSpeedButton;
    btnMenu: TMMSpeedButton;
    btnIncVolume: TMMSpeedButton;
    btnDecVolume: TMMSpeedButton;
    Bevel1: TBevel;
    Gauge: TMMLevel;
    Bevel2: TBevel;
    ledMode: TMMLEDMode;
    lblBitRate: TLabel;
    ledBitRate: TMMLEDPanel;
    lblLayer: TLabel;
    lblLayer2: TLabel;
    lblFile: TMMLEDLABEL;
    PopupMenu: TPopupMenu;
    Play1: TMenuItem;
    Stop1: TMenuItem;
    Pause1: TMenuItem;
    N4: TMenuItem;
    Info1: TMenuItem;
    MpegFile: TMMMPEGFile;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure HiTimerTimer(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnSkipLClick(Sender: TObject);
    procedure btnSkipRClick(Sender: TObject);
    procedure btnDecVolumeClick(Sender: TObject);
    procedure btnIncVolumeClick(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure MMPanelMouseDown(Sender: TObject; Button: TMouseButton;
                               Shift: TShiftState; X, Y: Integer);
    procedure MMPanelMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure MMPanelMouseUp(Sender: TObject; Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
    procedure btnMenuClick(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  public
    oMin, oSec: Word;
    Dragging: Boolean;
    DragStart: TPoint;

    Seeking: Boolean;
    OldTime,CurTime: Longint;
    TimeCnt: Longint;

    procedure DrawTime(Time: Longint);
    procedure SetFileParams;
    function  LoadFile(FileName: TFileName): Boolean;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.DrawTime(Time: Longint);
Var
   Hour, Min, Sec, MSec: Word;

begin
   { Display the "Time" }
   TimeDecode(Time, Hour, Min, Sec, MSec);

   if (oSec <> Sec) then
   begin
      ss1.Value := Sec;
      oSec := Sec;
   end;

   if (oMin <> Min) then
   begin
      mm1.Value := Min;
      oMin := Min;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.SetFileParams;
begin
   if not MpegFile.Empty then
   with MpegFile do
   begin
      ss1.Enabled  := True;
      ss2.Enabled  := True;
      mm1.Enabled  := True;
      mm2.Enabled  := True;
      digit.Enabled:= True;

      lblFile.Caption := UpperCase(ExtractFileName(Filename));

      lblLayer.Visible  := True;
      lblLayer2.Visible := True;
      case Layer of
          1: lblLayer2.Caption := 'I';
          2: lblLayer2.Caption := 'II';
          3: lblLayer2.Caption := 'III';
      end;

      if (Mode = smJointStereo) or (Mode = smStereo) then
         ledMode.Mode := mStereo
      else
         ledMode.Mode := mMono;
      ledMode.Enabled := True;

      ledBitRate.Value := BitRate;
      ledBitRate.Enabled := True;
      lblBitRate.Caption := 'KBit/s';
   end
   else
   begin
      ss1.Enabled  := False;
      ss2.Enabled  := False;
      mm1.Enabled  := False;
      mm2.Enabled  := False;
      digit.Enabled:= False;

      lblFile.Caption   := 'NO FILE';
      lblLayer.Visible  := False;
      lblLayer2.Visible := False;
      ledMode.Enabled   := False;
      ledBitRate.Enabled:= False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.HiTimerTimer(Sender: TObject);
var
   Time: Longint;
begin
   MMConnector1.Trigger;

   inc(TimeCnt);

   if (TimeCnt mod 5 = 0) and (wosPlay in Waveout.State) and not Seeking then
   begin
      Time := WaveOut.Position;
      inc(CurTime,Time-OldTime);
      DrawTime(CurTime);
      OldTime := Time;

      if not MpegFile.Empty then
      begin
         Gauge.Value := MulDiv(MpegFile.Position, 100, MpegFile.Frames);
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.WaveOutStart(Sender: TObject);
begin
   TimeCnt := 0;
   HiTimer.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.WaveOutStop(Sender: TObject);
begin
   HiTimer.Enabled := False;
   WaveOut.Close;
   DrawTime(0);
   Gauge.Value := 0;
end;

{-- TMainForm -----------------------------------------------------------}
function TMainForm.LoadFile(FileName: TFileName): Boolean;
begin
   Result := False;
   if (FileName <> '') and FileExists(FileName) then
   begin
      MpegFile.FileName := '';

      if IsMpegFile(FileName) then
      begin
         MpegFile.FileName := FileName;
         CurTime := 0;
         OldTime := 0;
         Result := True;
      end;
   end;
   SetFileParams;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.PopupMenuPopup(Sender: TObject);
begin
   { adjust menu entrys }
   if (wosPlay in WaveOut.State) then
   begin
      PopupMenu.Items[0].Caption := '&Restart';
      PopupMenu.Items[1].Enabled := True;
      PopupMenu.Items[2].Enabled := True;
   end
   else
   begin
      PopupMenu.Items[0].Caption := '&Play';
      PopupMenu.Items[1].Enabled := False;
      PopupMenu.Items[2].Enabled := False;
   end;

   if (wosPause in WaveOut.State) then
      PopupMenu.Items[2].Caption := '&UnPause'
   else
      PopupMenu.Items[2].Caption := '&Pause';
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnOpenClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      WaveOut.Stop;

      if not LoadFile(OpenDialog.FileName) then
         MessageDlg('This is not a valid Audiofile',mtWarning, [mbOK],0);

      SetFileParams;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnCloseClick(Sender: TObject);
begin
   Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnMenuClick(Sender: TObject);
var
   P: TPoint;
begin
   P := ButtonPanel.ClientToScreen(Point(btnMenu.Left,btnMenu.Top+btnMenu.Height));
   PopupMenu.Popup(P.X,P.Y);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPlayClick(Sender: TObject);
begin
   if not MpegFile.Empty then
   begin
      if not (wosPlay in WaveOut.State) then
      begin
         WaveOut.Start;
      end
      else if (wosPause in WaveOut.State) then
         WaveOut.Restart
      else
      begin
         WaveOut.Stop;
         WaveOut.Start;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPauseClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      if (wosPause in WaveOut.State) then
         WaveOut.Restart
      else
         WaveOut.Pause;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   WaveOut.Stop;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnSkipLClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      Seeking := True;
      WaveOut.Pause;

      MpegFile.Position := MpegFile.Position-(5000 div MpegFile.TimePerFrame);
      CurTime := MpegFile.Position*MpegFile.TimePerFrame;

      WaveOut.Reset;
      WaveOut.Restart;
      OldTime := 0;
      Seeking := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnSkipRClick(Sender: TObject);
begin
   if (wosPlay in WaveOut.State) then
   begin
      Seeking := True;
      WaveOut.Pause;

      if MpegFile.Position+(5000 div MpegFile.TimePerFrame) >= MpegFile.Frames then
      begin
         WaveOut.Stop;
         exit;
      end 
      else
      begin
         MpegFile.Position := MpegFile.Position+(5000 div MpegFile.TimePerFrame);
         CurTime := MpegFile.Position*MpegFile.TimePerFrame;
      end;

      WaveOut.Reset;
      WaveOut.Restart;
      OldTime := 0;
      Seeking := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnDecVolumeClick(Sender: TObject);
var
   Volume,L,R: Longint;
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOutGetVolume(WaveOut.Handle,@Volume);
      L := LoWord(Volume);
      R := HiWord(Volume);

      L := Max(L - 5000,0);
      R := Max(R - 5000,0);

      Volume := (R shl 16) + L;
      WaveOutSetVolume(WaveOut.Handle,Volume);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnIncVolumeClick(Sender: TObject);
var
   Volume,L,R: Longint;
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOutGetVolume(WaveOut.Handle,@Volume);
      L := LoWord(Volume);
      R := HiWord(Volume);

      L := Min(L + 5000,$FFFF);
      R := Min(R + 5000,$FFFF);

      Volume := (R shl 16) + L;
      WaveOutSetVolume(WaveOut.Handle,Volume);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMPanelMouseDown(Sender: TObject; Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
begin
   if (Button = mbLeft) then
   begin
      Dragging := True;
      DragStart := TControl(Sender).ClientToScreen(Point(X,Y));
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMPanelMouseUp(Sender: TObject; Button: TMouseButton;
                                   Shift: TShiftState; X, Y: Integer);
begin
   if (Button = mbLeft) then Dragging := False;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMPanelMouseMove(Sender: TObject; Shift: TShiftState;
                                     X, Y: Integer);
var
   Diff: TPoint;
begin
   if Dragging then
   begin
      Diff := TControl(Sender).ClientToScreen(Point(X,Y));
      Diff := Point(Diff.X-DragStart.X,Diff.Y-DragStart.Y);
      SetBounds(Left+Diff.X,Top+Diff.Y,Width,Height);
      DragStart.X := DragStart.X+Diff.X;
      DragStart.Y := DragStart.Y+Diff.Y;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Info1Click(Sender: TObject);
begin
   Show_AboutBox(0);
end;

procedure DecodeProc(lpBuffer: PChar; dwLength: Longint); stdcall;
var
   i: integer;
begin
   for i := 0 to dwLength-1 do PByteArray(lpBuffer)^[i] := PByteArray(lpBuffer)^[i] xor 128;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
//   MpegFile.SetDecodeCallback(DecodeProc);
end;

end.
